<?php
$configBaseUrl="https://wordpresspersistent.mystreamplayer.com/persistent-player/";

/*
Plugin Name: Persistent Player
Version: 1.0.0
Description: A persistent player that keeps playing while visitors explore your website
Author: Futuri Media
*/

// If the site hasn't loaded the iframe yet, 
// and we are not an any admin or login page,
// render the iframe and load the main site.
$isIframe = $_SERVER['HTTP_SEC_FETCH_DEST'] === 'iframe';
$isAdmin = strpos($_SERVER['REQUEST_URI'], 'wp-') !== false;
$isLogin = strpos($_SERVER['REQUEST_URI'], 'wp-login') !== false;
if(!$isAdmin && !$isLogin) {
    if(!$isIframe) {    
        $location = $_SERVER['REQUEST_SCHEME'] ."://". $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
            ?>
            <style>
                body {
                    margin: 0;
                    padding: 0;
                }
                .siteFrame {
                    display: block;
                    border: none;
                }
                .audioPlayer {
                    height: 85px !important;
                    width: 100vw;
                }
            </style>
            <?php
                echo "<iframe class='siteFrame' src='".$location."'  style='height: calc(100vh - 86px) !important; width: 100vw; border: none'></iframe>\n";
                if(!isset($configBaseUrl) || empty($configBaseUrl)) {
                    $configBaseUrl = 'https://player-stage.cdnstream.com/';
                }
                $configUrl = get_option('persistent_player_config_url', '');
                $configFullUrl = $configBaseUrl;
                if(!empty($configUrl)) {
                    $configFullUrl .= '?sid=' . $configUrl;
                }   
                else {
                    // Future error page that there is no config URL set.
                    //$configFullUrl .= '';
                }
                /// Audio Player
                echo '<iframe class="audioPlayer" src="'.$configFullUrl.'" style="height: 86px !important; width: 100vw; border: none"></iframe>';
             ?>
                <script>
                    
                    const iframe = document.querySelector('.siteFrame');
                    const audioPlayer = document.querySelector('.audioPlayer');
                    //window.history.pushState({url: document.location.href}, document.title, document.location.href);
                    iframe.addEventListener('load', trackIframeNavigation);
                    
                    // @todo The back button only handles one back event before it fails.
                    // Handle the back button event
                    window.addEventListener('popstate', function(event) {
                        event.preventDefault();
                        event.stopPropagation();
                        if (event.state) {
                            // Remove the previous load event listener to prevent recursion until the page is loaded
                            iframe.removeEventListener('load', trackIframeNavigation);
                            iframe.addEventListener('load', function() {
                                iframe.addEventListener('load', trackIframeNavigation);
                            });
                            iframe.src = event.state.url;
                        }
                    });

                    /**
                     * Track the navigation of the iframe and update the history state
                     */
                    function trackIframeNavigation() {
                        // Get the current URL of the iframe
                        let currentUrl = iframe.contentWindow.location.href;
                        let title = iframe.contentWindow.document.title;
                        let state = { page: title, url: currentUrl };
                        window.history.pushState(state, title, currentUrl);
                        
                        // Update the title of the main page to match the iframe's title
                        document.title = title;
                    }
                </script>
                </body>
                </html>
            <?php       
            exit;
    }
    else {
    // If the site has loaded the iframe, render the main site and let Wordpress handle it.
    ?>
    <script>
            /**
             * Find any clicks to external links and redirect the parent window to the new URL
             * @param {Event} event - The click event
             * @todo handle target="_blank" links
             */
            document.addEventListener('click', function(event) {
                if (event.target.tagName === 'A') {
                    const newUrl = event.target.href;
                    if (new URL(newUrl).origin !== window.location.origin) {
                        event.preventDefault(); // Prevent the link from navigating in the iframe (so the back button works as expected if returning to the page)
                        event.stopPropagation(); // Stop the event from bubbling up to the parent window
                        window.parent.location.href = newUrl; // Redirect the parent window to the new URL
                    }
                }
            });
    </script>
    <?php
    }
} else {
    // Do nothing if it's in the admin, login, or any WP specific page
    add_action('admin_menu', function() {
        add_options_page(
            'Persistent Player Settings',
            'Persistent Player',
            'manage_options',
            'persistent-player-settings',
            function() {
                ?>
                <div class="wrap">
                    <h1>Persistent Player Settings</h1>
                    <form method="post" action="options.php">
                        <?php
                        settings_fields('persistent_player_settings_group');
                        do_settings_sections('persistent-player-settings');
                        submit_button();
                        ?>
                    </form>
                </div>
                <?php
            }
        );
    });

    add_action('admin_init', function() {
        register_setting('persistent_player_settings_group', 'persistent_player_config_url');

        add_settings_section(
            'persistent_player_settings_section',
            'Player Configuration',
            null,
            'persistent-player-settings'
        );

        add_settings_field(
            'persistent_player_config_url',
            'Player Config Path',
            function() {
                $value = get_option('persistent_player_config_url', '');
                echo "<input type='text' name='persistent_player_config_url' value='{$value}' class='regular-text' />";
            },
            'persistent-player-settings',
            'persistent_player_settings_section'
        );
    });
}
